// convert.js

const convertBtn = document.getElementById('convertBtn');

convertBtn.addEventListener('click', async () => {
	// FIX 1: Access window.selectedFile (defined in fileHandler.js)
	if (!window.selectedFile) return;

	const formData = new FormData();
	// FIX 2: Access window.selectedFile
	formData.append('file', window.selectedFile);

	// FIX 3: Access window.showLoading() (defined in helpers.js)
	window.showLoading();
	convertBtn.disabled = true;

	try {
		const response = await fetch('/convert-to-jpg', {
			method: 'POST',
			body: formData
		});

		if (response.ok) {
			const contentDisposition = response.headers.get('Content-Disposition');
			let filename = "converted_images.zip";
			if (contentDisposition) {
				const filenameMatch = contentDisposition.match(/filename="(.+?)"/);
				if (filenameMatch && filenameMatch.length > 1) {
					filename = filenameMatch[1];
				}
			}

			const blob = await response.blob();
			// FIX 4: Access window.downloadFile() (defined in helpers.js)
			window.downloadFile(blob, filename);

			// FIX 5: Access window.showMessage() (defined in helpers.js)
			window.showMessage(`✅ Conversion successful! Downloaded: ${filename}`, 'success');
		} else {
			const errorText = await response.text();
			// FIX 6: Access window.showMessage()
			window.showMessage(`❌ Conversion failed (${response.status}). Details: ${errorText.substring(0, 100)}`, 'error');
		}
	} catch (error) {
		// FIX 7: Access window.showMessage()
		window.showMessage('❌ Network Error: Could not reach the server.', 'error');
	} finally {
		// FIX 8: Access window.hideLoading() (defined in helpers.js)
		window.hideLoading();
		convertBtn.disabled = false;
	}
});

