/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.graph.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.graph.AttributeNode;
import org.hibernate.graph.CannotBecomeEntityGraphException;
import org.hibernate.graph.CannotContainSubGraphException;
import org.hibernate.graph.internal.AbstractGraphNode;
import org.hibernate.graph.internal.AttributeNodeImpl;
import org.hibernate.graph.internal.RootGraphImpl;
import org.hibernate.graph.spi.AttributeNodeImplementor;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;

public abstract class AbstractGraph<J>
extends AbstractGraphNode<J>
implements GraphImplementor<J> {
    private final ManagedDomainType<J> managedType;
    private Map<PersistentAttribute<?, ?>, AttributeNodeImplementor<?>> attrNodeMap;

    public AbstractGraph(ManagedDomainType<J> managedType, boolean mutable) {
        super(mutable);
        this.managedType = managedType;
    }

    protected AbstractGraph(GraphImplementor<J> original, boolean mutable) {
        this(original.getGraphedType(), mutable);
        this.attrNodeMap = new ConcurrentHashMap(original.getAttributeNodeList().size());
        original.visitAttributeNodes(node -> this.attrNodeMap.put(node.getAttributeDescriptor(), (AttributeNodeImplementor<?>)node.makeCopy(mutable)));
    }

    @Override
    public ManagedDomainType<J> getGraphedType() {
        return this.managedType;
    }

    @Override
    public RootGraphImplementor<J> makeRootGraph(String name, boolean mutable) {
        if (this.getGraphedType() instanceof EntityDomainType) {
            return new RootGraphImpl(name, this, mutable);
        }
        throw new CannotBecomeEntityGraphException("Cannot transform Graph to RootGraph - " + this.getGraphedType() + " is not an EntityType");
    }

    @Override
    public void merge(GraphImplementor<? extends J> other) {
        if (other == null) {
            return;
        }
        for (AttributeNodeImplementor<?> attributeNode : other.getAttributeNodeImplementors()) {
            AttributeNode localAttributeNode = this.findAttributeNode(attributeNode.getAttributeDescriptor());
            if (localAttributeNode != null) {
                localAttributeNode.merge(attributeNode);
                continue;
            }
            this.addAttributeNode((AttributeNodeImplementor<?>)attributeNode.makeCopy(true));
        }
    }

    @Override
    public AttributeNodeImplementor<?> addAttributeNode(AttributeNodeImplementor<?> incomingAttributeNode) {
        this.verifyMutability();
        AttributeNodeImplementor<?> attributeNode = null;
        if (this.attrNodeMap == null) {
            this.attrNodeMap = new HashMap();
        } else {
            attributeNode = this.attrNodeMap.get(incomingAttributeNode.getAttributeDescriptor());
        }
        if (attributeNode == null) {
            attributeNode = incomingAttributeNode;
            this.attrNodeMap.put(incomingAttributeNode.getAttributeDescriptor(), attributeNode);
        } else {
            AttributeNodeImplementor<?> attributeNodeFinal = attributeNode;
            incomingAttributeNode.visitSubGraphs((subType, subGraph) -> attributeNodeFinal.addSubGraph((SubGraphImplementor<?>)subGraph));
        }
        return attributeNode;
    }

    @Override
    public <AJ> AttributeNodeImplementor<AJ> findAttributeNode(String attributeName) {
        PersistentAttribute<J, ?> attribute = this.managedType.findAttributeInSuperTypes(attributeName);
        return attribute == null ? null : this.findAttributeNode(attribute);
    }

    @Override
    public <AJ> AttributeNodeImplementor<AJ> findAttributeNode(PersistentAttribute<? extends J, AJ> attribute) {
        return this.attrNodeMap == null ? null : this.attrNodeMap.get(attribute);
    }

    @Override
    public List<AttributeNode<?>> getGraphAttributeNodes() {
        return this.getAttributeNodeImplementors();
    }

    @Override
    public List<AttributeNodeImplementor<?>> getAttributeNodeImplementors() {
        return this.attrNodeMap == null ? Collections.emptyList() : new ArrayList(this.attrNodeMap.values());
    }

    @Override
    public <AJ> AttributeNodeImplementor<AJ> addAttributeNode(String attributeName) throws CannotContainSubGraphException {
        return this.findOrCreateAttributeNode(attributeName);
    }

    @Override
    public <AJ> AttributeNodeImplementor<AJ> addAttributeNode(PersistentAttribute<? extends J, AJ> attribute) throws CannotContainSubGraphException {
        return this.findOrCreateAttributeNode(attribute);
    }

    @Override
    public <AJ> AttributeNodeImplementor<AJ> findOrCreateAttributeNode(PersistentAttribute<? extends J, AJ> attribute) {
        this.verifyMutability();
        AttributeNodeImplementor<?> attrNode = null;
        if (this.attrNodeMap == null) {
            this.attrNodeMap = new HashMap();
        } else {
            attrNode = this.attrNodeMap.get(attribute);
        }
        if (attrNode == null) {
            attrNode = new AttributeNodeImpl<AJ>(attribute, this.isMutable());
            this.attrNodeMap.put(attribute, attrNode);
        }
        return attrNode;
    }
}

